<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCountryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:6|unique:countries,code',
            'phone_code' => 'required|string|max:255',
            'currency' => 'required|string|max:255',
            'currency_symbol' => 'nullable|string|max:255',
            'status' => 'nullable|boolean',
            'flag' => 'required|image|mimes:jpeg,png,jpg|max:1024',
        ];
    }
}
